class Lager {
	private int bilanz;
 	private int anz;
	private boolean konsumentDa;
 	private static final int MANZ = 20;

	Lager(int start) {
		bilanz = start;
		System.out.println("Der Laden ist offen (Bestand = " + bilanz+")\n");
	}

	synchronized boolean istOffen() {
		if (anz < MANZ || konsumentDa)
			return true;
		else {
			System.out.println("\nLieber " + Thread.currentThread().getName() +
				", es ist Feierabend!");
			return false;
		}
	}

	private String formZeit() {
		return java.text.DateFormat.getTimeInstance().format(new java.util.Date());
	}

	synchronized void ergaenze(int add) {
		bilanz += add;
		anz++;
		System.out.println("Nr. " + anz + ":\t"+Thread.currentThread().getName() +
			" ergänzt\t" + add + "\tum " + formZeit() + " Uhr. Stand: " + bilanz);
		notify();
	}


	synchronized void liefere(int sub) {
		konsumentDa = true;
		while (bilanz < sub)
			try {
				System.out.println(Thread.currentThread().getName() +
					" muss warten: Keine " + sub + " Einheiten vorhanden.");
				wait();
			} catch (InterruptedException ie) {
				// Die Ausnahme darf ignoriert werden, weil der Thread
				// keine Unterbrechungsaufforderung erhält.
			}
		bilanz -= sub;
		anz++;
		System.out.println("Nr. " + anz + ":\t" + Thread.currentThread().getName() +
			" entnimmt\t" + sub + "\tum " + formZeit() + " Uhr. Stand: " + bilanz);
		konsumentDa = false;
	}
}